/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.pngwalk.ImageResize;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.pngwalk.QualityControlRecord;
import org.autoplot.pngwalk.WalkImageSequence;
import org.das2.util.LoggerManager;

public abstract class PngWalkView
extends JPanel
implements PropertyChangeListener {
    static final Logger logger = LoggerManager.getLogger((String)"autoplot.pngwalk");
    protected WalkImageSequence seq;
    protected boolean showCaptions = false;
    protected static final BufferedImage loadingImage = PngWalkView.initLoadingImage();
    protected static final BufferedImage tinyLoadingImage = PngWalkView.initTinyLoadingImage();
    protected static final ImageIcon okBadge;
    protected static final ImageIcon problemBadge;
    protected static final ImageIcon ignoreBadge;
    protected int thumbnailSize = 100;
    public static final String PROP_THUMBNAILSIZE = "thumbnailSize";

    protected PngWalkView(WalkImageSequence sequence) {
        this.setSequence(sequence);
        this.setFocusable(true);
    }

    public final void setSequence(WalkImageSequence sequence) {
        if (this.seq != null) {
            this.seq.removePropertyChangeListener(this);
        }
        this.seq = sequence;
        if (this.seq != null) {
            this.seq.addPropertyChangeListener(this);
        }
        this.sequenceChanged();
    }

    public WalkImageSequence getSequence() {
        return this.seq;
    }

    protected void sequenceChanged() {
        this.repaint();
    }

    protected void thumbnailSizeChanged() {
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("sequenceChanged")) {
            this.sequenceChanged();
        } else {
            this.repaint();
        }
    }

    public boolean isShowCaptions() {
        return this.showCaptions;
    }

    public void setShowCaptions(boolean showCaptions) {
        this.showCaptions = showCaptions;
    }

    public int getThumbnailSize() {
        return this.thumbnailSize;
    }

    public void setThumbnailSize(int thumbnailSize) {
        int oldThumbnailSize = this.thumbnailSize;
        this.thumbnailSize = thumbnailSize;
        this.thumbnailSizeChanged();
        this.firePropertyChange(PROP_THUMBNAILSIZE, oldThumbnailSize, thumbnailSize);
    }

    public JComponent getMouseTarget() {
        return this;
    }

    public MouseWheelListener getMouseWheelListener() {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getModifiersEx() == 0 && PngWalkView.this.seq != null && PngWalkView.this.seq.size() != 0) {
                    PngWalkView.this.seq.skipBy(e.getWheelRotation());
                }
            }
        };
    }

    public JPopupMenu getPopup() {
        JPopupMenu m = new JPopupMenu();
        m.add(new JMenuItem(new AbstractAction("Save local copy..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PngWalkView.this.seq == null) {
                    return;
                }
                String file = DataSetURI.fromUri((URI)PngWalkView.this.seq.currentImage().getUri());
                PngWalkTool.saveLocalCopy(PngWalkView.this, file);
            }
        }));
        m.add(new JMenuItem(new AbstractAction("Copy to clipboard..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PngWalkView.this.seq == null) {
                    return;
                }
                String file = DataSetURI.fromUri((URI)PngWalkView.this.seq.currentImage().getUri());
                PngWalkTool.copyToClipboard(PngWalkView.this, file);
            }
        }));
        return m;
    }

    protected void drawCenteredString(Graphics2D g, String msg) {
        if (msg == null) {
            return;
        }
        System.err.println("draw string");
        Rectangle bounds = g.getClipBounds();
        if (bounds != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            g.drawString(msg, (bounds.width - fm.stringWidth(msg)) / 2, bounds.height / 2);
        } else {
            System.err.println("bad clipping");
        }
    }

    protected Rectangle paintImageCentered(BufferedImage i, Graphics2D g2) {
        return this.paintImageCentered(i, g2, null);
    }

    protected Rectangle paintImageCentered(BufferedImage i, Graphics2D g2, String caption) {
        double yfactor;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        double captionHeight = this.showCaptions && caption != null ? (double)(fm.getHeight() + fm.getDescent()) : 0.0;
        double imageHeight = i.getHeight();
        double xfactor = (double)this.getWidth() / (double)i.getWidth(null);
        double s = Math.min(xfactor, yfactor = ((double)this.getHeight() - captionHeight) / imageHeight);
        if (s <= 0.0) {
            return null;
        }
        s = Math.min(1.0, s);
        int xpos = (int)((double)this.getWidth() - (double)i.getWidth(null) * s) / 2;
        int ypos = (int)((double)this.getHeight() - captionHeight - imageHeight * s) / 2;
        int xs = (int)((double)i.getWidth(null) * s);
        int ys = (int)((double)i.getHeight(null) * s);
        if (i == loadingImage) {
            g2.drawImage((Image)i, xpos, ypos, this);
        } else {
            BufferedImage resize = ImageResize.getScaledInstance(i, xs, ys, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
            g2.drawImage((Image)resize, xpos, ypos, this);
        }
        if (this.showCaptions && caption != null) {
            int cx = xpos;
            int cy = ypos + ys + fm.getHeight();
            g2.drawString(caption, cx, cy);
        }
        if (PngWalkTool.isQualityControlEnabled() && this.seq.getQualityControlSequence() != null) {
            this.paintQualityControlIcon(this.seq.getIndex(), g2, xpos, ypos, true);
            QualityControlRecord rec = this.seq.getQualityControlSequence().getQualityControlRecord(this.seq.getIndex());
            if (rec != null) {
                int cx = xpos;
                int cy = ypos + ys + 2 * fm.getHeight();
                g2.drawString(rec.getLastComment(), cx, cy);
            }
        }
        return new Rectangle(xpos, ypos, xs, ys);
    }

    private static BufferedImage initLoadingImage() {
        BufferedImage li = new BufferedImage(48, 48, 2);
        Graphics2D g2 = li.createGraphics();
        g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        g2.fillRoundRect(0, 0, 48, 48, 6, 6);
        g2.setColor(Color.WHITE);
        g2.fillOval(12, 32, 4, 4);
        g2.fillOval(24, 32, 4, 4);
        g2.fillOval(36, 32, 4, 4);
        return li;
    }

    private static BufferedImage initTinyLoadingImage() {
        BufferedImage li = new BufferedImage(8, 8, 2);
        Graphics2D g2 = li.createGraphics();
        g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        g2.fillRoundRect(0, 0, 8, 8, 4, 4);
        g2.setColor(Color.WHITE);
        g2.fillOval(2, 2, 4, 4);
        return li;
    }

    protected void paintQualityControlIcon(int i, Graphics2D g2, int imgX, int imgY, boolean icon) {
        QualityControlRecord rec = this.seq.getQualityControlSequence().getQualityControlRecord(i);
        if (okBadge == null) {
            throw new RuntimeException("unable to locate all badges for quality control");
        }
        if (rec != null) {
            if (icon) {
                switch (rec.getStatus()) {
                    case OK: {
                        okBadge.paintIcon(this, g2, imgX + 5, imgY + 5);
                        break;
                    }
                    case PROBLEM: {
                        problemBadge.paintIcon(this, g2, imgX + 5, imgY + 5);
                        break;
                    }
                    case IGNORE: {
                        ignoreBadge.paintIcon(this, g2, imgX + 5, imgY + 5);
                        break;
                    }
                }
            } else {
                Color color0 = g2.getColor();
                switch (rec.getStatus()) {
                    case OK: {
                        g2.setColor(Color.GREEN);
                        break;
                    }
                    case PROBLEM: {
                        g2.setColor(Color.RED);
                        break;
                    }
                    case IGNORE: {
                        g2.setColor(Color.GRAY);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                g2.fillOval(imgX, imgY, 6, 6);
                g2.setColor(Color.GRAY);
                g2.drawOval(imgX, imgY, 6, 6);
                g2.setColor(color0);
            }
        }
    }

    int getNextInterval(int index) {
        return index + 7;
    }

    int getNextPage(int index) {
        return index + 28;
    }

    int getPrevInterval(int index) {
        return index - 7;
    }

    int getPrevPage(int index) {
        return index - 28;
    }

    static {
        URL u = PngWalkView.class.getResource("/resources/badge_problem.png");
        problemBadge = u != null ? new ImageIcon(u) : null;
        u = PngWalkView.class.getResource("/resources/badge_ok.png");
        okBadge = u != null ? new ImageIcon(u) : null;
        u = PngWalkView.class.getResource("/resources/badge_ignore.png");
        ignoreBadge = u != null ? new ImageIcon(u) : null;
    }
}

